rm(list=ls())
library(neuralnet)

setwd("H:/My Documents/Morphometric stuff/Analysis with Eddy data")
filename<-read.table("Allshells with Eddy - for R.txt",header=T)
placo <- filename

trainDataNN <- placo[which(placo$data=='E'),]
newData_ <- placo[which(placo$data=='M'),]
newData <- newData_[,4:6]

#### Set up boolean vectors for training phase
trainDataNN$Pf 
trainDataNN$Pp
for(i in 1:27){
  if(trainDataNN$class[i]=='Pf') trainDataNN$Pf[i]=1
  else trainDataNN$Pf[i]=0
}
for(i in 1:27){
  if(trainDataNN$class[i]=='Pp') trainDataNN$Pp[i]=1
  else trainDataNN$Pp[i]=0
}

#### Normalize input data using min-max function
scl <- function(x){ (x - min(x))/(max(x) - min(x)) }
trainDataNN[, 4:10] <- data.frame(lapply(trainDataNN[, 4:10], scl))
newData <- data.frame(lapply(newData, scl))

#### Set up one neural network model and compute outputs on new values
f <- as.formula("Pf + Pp ~  PC1 + PC2 + Centroid")
nn <- neuralnet(f,data=trainDataNN,hidden=c(5,3),act.fct = "logistic",linear.output=F,lifesign="minimal")
plot(nn)
pr.nn <- compute(nn, newData)
pr.nn_ <- pr.nn$net.result
head(pr.nn_)

#### Plot results in a barplot
barplot(t(pr.nn_),col = rainbow(6), border = NA, space = 0,xlab = "Individuals", ylab = "Admixture coefficients")


#### Compute k neural network models and average output predicted values

set.seed(500)
k <- 1000
outs <- NULL
proportion <- 0.80 
Pr.pf <- matrix(nrow=336,ncol=k)
Pr.pp <- matrix(nrow=336,ncol=k)
# Loop
for(i in 1:k){
  nn_cv <- neuralnet(f,
                     data = trainDataNN,
                     hidden = c(5,3),
                     act.fct = "logistic",
                     linear.output = FALSE)
  pr.nn <- compute(nn_cv, newData)
  pr.nn_ <- pr.nn$net.result
  Pr.pf[,i] <- pr.nn_[,1]
  Pr.pp[,i] <- pr.nn_[,2]
}

Pr.pfm <- vector("numeric",336)
Pr.ppm <- vector("numeric",336)
l <- 336
for(i in 1:l){
  Pr.pfm[i] <- mean(Pr.pf[i,])
}

for(i in 1:l){
  Pr.ppm[i] <- mean(Pr.pp[i,])
}
out <- cbind(Pr.pfm,Pr.ppm)
write.table(out,file="outneural.txt")

#### Plots output results in a barplot
barplot(t(out),col = rainbow(6), border = NA, space = 0,xlab = "Individuals", ylab = "Admixture coefficients")





